//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

Text {
    id : uiText

    property bool highlight : false
    property bool italic : false

    font : UiFonts.getFont(
               italic ? UiFonts.LightItalic : UiFonts.Light, 14)
    color : {
        if (!enabled) {
            return UiColors.getColor(UiColors.MediumLightGrey27);
        } else if (highlight) {
            UiColors.getColor(UiColors.White);
        } else {
            return UiColors.getColor(UiColors.DarkGrey80);
        }
    }
    elide : Text.ElideRight
    wrapMode : Text.NoWrap
}

